﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kasa" %>
<script runat="server">

    class SpecyfikacjaNominałów {
    
            static readonly public SpecyfikacjaNominałów Empty = new SpecyfikacjaNominałów();
    
            static decimal[] nominały = new decimal[] { 200.0m, 100.0m, 50.0m, 20.0m, 10.0m, 5.0m, 2.0m, 1.0m, 0.50m, 0.20m, 0.10m, 0.05m, 0.02m, 0.01m };
            decimal kwota;
            Hashtable ht = new Hashtable();
    
            private SpecyfikacjaNominałów() {
            }
            public SpecyfikacjaNominałów(decimal kwota) {
                this.kwota = kwota;
                Przelicz();
            }
            public decimal Kwota {
                get { return kwota; }
            }
            public decimal Suma {
                get {
                    decimal suma = 0;
                    for (int i=0; i<nominały.Length; i++)
                        suma += nominały[i] * this[nominały[i]] ;
                    return suma;
                }
            }
            public int this [decimal nominał] {
                get {
                    object n = ht[nominał];
                    return n==null ? 0 : (int)n;
                }
            }
            void Przelicz() {
                decimal k = kwota;
                for (int i=0; i<nominały.Length; i++) {
                    int n = (int)decimal.Floor(k/nominały[i]);
                    k -= n*nominały[i];
                    if (n>0)
                        ht[nominały[i]] = n;
                }
            }
            public static SpecyfikacjaNominałów operator + (SpecyfikacjaNominałów a, SpecyfikacjaNominałów b) {
                SpecyfikacjaNominałów sn = new SpecyfikacjaNominałów();
                for (int i=0; i<nominały.Length; i++) {
                    int n = a[nominały[i]] + b[nominały[i]];
                    if (n>0)
                        sn.ht[nominały[i]] = n;
                }
                sn.kwota = a.kwota + b.kwota;
                return sn;
            }
            public static SpecyfikacjaNominałów operator + (SpecyfikacjaNominałów a, decimal kwota) {
                return a + new SpecyfikacjaNominałów(kwota);
            }
        }
    
        SpecyfikacjaNominałów razem = SpecyfikacjaNominałów.Empty;
    
        void OnContextLoad(Object sender, EventArgs args) {
            Row[] lps = (Row[])dc[typeof(Row[])];
            ArrayList lista = new ArrayList(lps);
            lista.Add(1);
            DataRepeater1.DataSource = lista;
            Grid1.DataSource = new object[0];
        }
    
        void DataRepeater1_BeforeRow(object sender, EventArgs e) {
            object obj = DataRepeater1.CurrentRow;
    
            SpecyfikacjaNominałów sn = SpecyfikacjaNominałów.Empty;
    
            if (obj is ListaPlac) {
                DataLabel1.EditValue = "Lista płac: <B>" + obj + "</B>";
                ListaPlac lp = (ListaPlac)obj;
                foreach (Soneta.Place.Wyplata w in lp.Wyplaty)
                    sn += DoWypłaty(w);
                razem += sn;
                Grid1.DataSource = new object[] {sn};
                DataLabel2.EditValue = sn.Kwota;
            }
            else {
                DataLabel1.EditValue = "<B>Razem listy płac</B>";
                Grid1.DataSource = new object[] {razem};
                DataLabel2.EditValue = razem.Kwota;
            }
        }
    
        decimal DoWypłaty(Soneta.Place.Wyplata w) {
            decimal suma = 0m;
            foreach (Platnosc p in w.Platnosci)
                if (p is Zobowiazanie && !p.Automatyczne && p.SposobZaplaty.Typ==TypySposobowZaplaty.Gotówka)
                    suma += p.Kwota.Value;
            return suma;
        }
    
        void Grid1_BeforeRow(object sender, RowEventArgs e) {
            SpecyfikacjaNominałów sn = (SpecyfikacjaNominałów)e.Row;
            p200.EditValue = string.Format("{0}<br>{1:n}",  sn[200m],   sn[200m]*   200m);
            p100.EditValue = string.Format("{0}<br>{1:n}",  sn[100m],   sn[100m]*   100m);
            p50.EditValue = string.Format("{0}<br>{1:n}",   sn[50m],    sn[50m]*    50m);
            p20.EditValue = string.Format("{0}<br>{1:n}",   sn[20m],    sn[20m]*    20m);
            p10.EditValue = string.Format("{0}<br>{1:n}",   sn[10m],    sn[10m]*    10m);
            p5.EditValue = string.Format("{0}<br>{1:n}",    sn[5m],     sn[5m]*     5m);
            p2.EditValue = string.Format("{0}<br>{1:n}",    sn[2m],     sn[2m]*     2m);
            p1.EditValue = string.Format("{0}<br>{1:n}",    sn[1m],     sn[1m]*     1m);
            p05.EditValue = string.Format("{0}<br>{1:n}",   sn[0.5m],   sn[0.5m]*   0.5m);
            p02.EditValue = string.Format("{0}<br>{1:n}",   sn[0.2m],   sn[0.2m]*   0.2m);
            p01.EditValue = string.Format("{0}<br>{1:n}",   sn[0.1m],   sn[0.1m]*   0.1m);
            p005.EditValue = string.Format("{0}<br>{1:n}",  sn[0.05m],  sn[0.05m]*  0.05m);
            p002.EditValue = string.Format("{0}<br>{1:n}",  sn[0.02m],  sn[0.02m]*  0.02m);
            p001.EditValue = string.Format("{0}<br>{1:n}",  sn[0.01m],  sn[0.01m]*  0.01m);
        }
    
        void Msg(object obj) {
        }

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Specyfikacja nominałów</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="ZestawienieListPłac" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
        <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Specyfikacja nominałów" runat="server"></cc1:reportheader>
        <ea:datarepeater id="DataRepeater1" runat="server" Height="77px" Width="100%" OnBeforeRow="DataRepeater1_BeforeRow">
            <p>
                <ea:DataLabel id="DataLabel1" runat="server" Bold="False"></ea:DataLabel>
                , do wypłaty: 
                <ea:DataLabel id="DataLabel2" runat="server" Format="{0:n}"></ea:DataLabel>
                <br />
                <ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" WithSections="False">
                    <Columns>
                        <ea:GridColumn Width="10" Align="Right" Caption="200" ID="p200"></ea:GridColumn>
                        <ea:GridColumn Width="10" Align="Right" Caption="100" ID="p100"></ea:GridColumn>
                        <ea:GridColumn Width="9" Align="Right" Caption="50" ID="p50"></ea:GridColumn>
                        <ea:GridColumn Width="9" Align="Right" Caption="20" ID="p20"></ea:GridColumn>
                        <ea:GridColumn Width="9" Align="Right" Caption="10" ID="p10"></ea:GridColumn>
                        <ea:GridColumn Width="8" Align="Right" Caption="5" ID="p5"></ea:GridColumn>
                        <ea:GridColumn Width="8" Align="Right" Caption="2" ID="p2"></ea:GridColumn>
                        <ea:GridColumn Width="8" Align="Right" Caption="1" ID="p1"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="0,50" ID="p05"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="0,20" ID="p02"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="0,10" ID="p01"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="0,05" ID="p005"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="0,02" ID="p002"></ea:GridColumn>
                        <ea:GridColumn Align="Right" Caption="0,01" ID="p001"></ea:GridColumn>
                    </Columns>
                </ea:grid>
            </p>
        </ea:datarepeater>
        <cc1:reportfooter id="ReportFooter1" runat="server" Height="334px">
            <Subtitles>
                <cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
                <cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
            </Subtitles>
        </cc1:reportfooter>
    </form>
</body>
</html>
